@extends('layouts.app')
@section('title', __('lang_v1.add_stock_transfer'))

@section('content')

    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Intercompany Sales</h1>
    </section>

    <!-- Main content -->
    <section class="content no-print">
        {!! Form::open([
            'url' => action([\App\Http\Controllers\StockTransferController::class, 'store']),
            'method' => 'post',
            'id' => 'stock_transfer_form',
        ]) !!}

        @component('components.widget', ['class' => 'box-solid'])
            <div class="row">
                <div class="col-sm-4">
                    <div class="form-group">
                        {!! Form::label('transaction_date', __('messages.date') . ':*') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                            </span>
                            {!! Form::text('transaction_date', @format_datetime('now'), ['class' => 'form-control', 'readonly', 'required']) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        {!! Form::label('ref_no', __('purchase.ref_no') . ':') !!}
                        {!! Form::text('ref_no', null, ['class' => 'form-control']) !!}
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        {!! Form::label('status', __('sale.status') . ':*') !!} @show_tooltip(__('lang_v1.completed_status_help'))
                        @php $__st = $statuses; @endphp
                        @unless(auth()->user()->can('stock_transfer.set_completed_status'))
                            @php unset($__st['completed']); @endphp
                        @endunless
                        {!! Form::select('status', $__st, null, [
                            'class' => 'form-control select2',
                            'placeholder' => __('messages.please_select'),
                            'required',
                            'id' => 'status',
                        ]) !!}
                    </div>
                </div>
                <div class="clearfix"></div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('location_id', __('lang_v1.location_from') . ':*') !!}
                        {!! Form::select('location_id', $business_locations, null, [
                            'class' => 'form-control select2',
                            'placeholder' => __('messages.please_select'),
                            'required',
                            'id' => 'location_id',
                        ]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('transfer_location_id', __('lang_v1.location_to') . ':*') !!}
                        {!! Form::select('transfer_location_id', $business_locations, null, [
                            'class' => 'form-control select2',
                            'placeholder' => __('messages.please_select'),
                            'required',
                            'id' => 'transfer_location_id',
                        ]) !!}
                    </div>
                </div>

            </div>
        @endcomponent

        <!-- end-->
        @component('components.widget', ['class' => 'box-solid'])
            <div class="row">
                <div class="col-sm-8 col-sm-offset-2">
                    <div class="form-group">
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-search"></i>
                            </span>
                            {!! Form::text('search_product', null, [
                                'class' => 'form-control',
                                'id' => 'search_product_for_srock_adjustment',
                                'placeholder' => __('stock_adjustment.search_product'),
                                'disabled',
                            ]) !!}
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-10 col-sm-offset-1">
                    <input type="hidden" id="product_row_index" value="0">
                    <input type="hidden" id="total_amount" name="final_total" value="0">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-condensed" id="stock_adjustment_product_table">
                            <thead>
                                <tr>
                                    <th class="col-sm-4 text-center">
                                        @lang('sale.product')
                                    </th>
                                    <th class="col-sm-2 text-center">
                                        @lang('sale.qty')
                                    </th>
                                    <th class="col-sm-2 text-center show_price_with_permission">
                                        @lang('sale.unit_price')
                                    </th>
                                    <th class="col-sm-2 text-center show_price_with_permission">
                                        @lang('sale.subtotal')
                                    </th>
                                    <th class="col-sm-2 text-center"><i class="fa fa-trash" aria-hidden="true"></i></th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                            <tfoot>
                                <tr class="text-center show_price_with_permission">
                                    <td colspan="3"></td>
                                    <td>
                                        <div class="pull-right"><b>@lang('sale.total'): </b> <span
                                                id="total_adjustment">0.00</span></div>
                                    </td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        @endcomponent


        @component('components.widget', ['class' => 'box-solid'])
            <div class="row">
                <div class="col-sm-4">
                    <div class="form-group">
                        {!! Form::label('shipping_charges', __('lang_v1.shipping_charges') . ':') !!}
                        {!! Form::text('shipping_charges', 0, [
                            'class' => 'form-control input_number',
                            'placeholder' => __('lang_v1.shipping_charges'),
                        ]) !!}
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        {!! Form::label('additional_notes', __('purchase.additional_notes')) !!}
                        {!! Form::textarea('additional_notes', null, ['class' => 'form-control', 'rows' => 3]) !!}
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12 text-right show_price_with_permission">
                    <b>@lang('stock_adjustment.total_amount'):</b> <span id="final_total_text">0.00</span>
                </div>
                <br>
                <br>
                <div class="col-sm-12 text-center">
                    <button type="submit" id="save_stock_transfer" class="tw-dw-btn tw-dw-btn-primary tw-dw-btn-lg tw-text-white">@lang('messages.save')</button>
                </div>
            </div>
        @endcomponent

        {!! Form::close() !!}
    </section>
@stop
@section('javascript')
    <script src="{{ asset('js/stock_transfer.js?v=' . $asset_v) }}"></script>
    <script type="text/javascript">
        __page_leave_confirmation('#stock_transfer_form');
    </script>

    {{-- >>> Add: pretty suggestions (Name • SKU • Supplier) for the product search --}}
    <style>
        .ui-autocomplete{max-width:680px}
        .sa-suggest{padding:8px 10px}
        .sa-name{font-weight:600}
        .sa-meta{font-size:.85rem;opacity:.85}
        .sa-meta span{margin-right:14px}
    </style>
    <script>
    (function(){
        // simple HTML escaper
        function esc(s){
            return String(s ?? '').replace(/[&<>"'`=\/]/g, c => ({
                '&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;','/':'&#x2F;','`':'&#x60;','=':'&#x3D;'
            }[c]));
        }

        var $inp = $('#search_product_for_srock_adjustment'); // your input id

        // stock_transfer.js initializes jQuery-UI autocomplete.
        // We only customize how each item is *rendered* (no change to behavior).
        function attachRenderer(){
            var inst = $inp.autocomplete('instance') || $inp.data('ui-autocomplete');
            if(!inst || inst.__customized) return false;

            inst.__customized = true;
            var _old = inst._renderItem;

            inst._renderItem = function(ul, item){
                // Try common keys from your backend; fall back gracefully
                var name = item.product_name || item.name || item.text || '';
                var sku  = item.sku || item.sub_sku || item.sku_code || '';
                var sup  = item.supplier_name || item.supplier || item.contact_name || '';

                // If backend doesn’t provide supplier_name yet, it will just show “-”
                return $('<li>')
                    .append(
                        '<div class="sa-suggest">'
                          + '<div class="sa-name">' + esc(name) + '</div>'
                          + '<div class="sa-meta">'
                            + '<span>SKU: ' + esc(sku || '-') + '</span>'
                            + '<span>Supplier: ' + esc(sup || '-') + '</span>'
                          + '</div>'
                        + '</div>'
                    )
                    .appendTo(ul);
            };
            return true;
        }

        // Try now; if autocomplete is attached later by stock_transfer.js, hook events too
        $(function(){
            if(!attachRenderer()){
                // When menu opens the first time, instance exists—then we attach our renderer
                $inp.on('autocompleteopen', attachRenderer);
                // Fallback timer (in case open doesn't fire due to no results yet)
                var tries = 0, t = setInterval(function(){
                    if(attachRenderer() || ++tries > 20) clearInterval(t);
                }, 200);
            }
        });
    })();
    </script>

    {{-- ===== Require Lot & Expiry before saving (Intercompany Sales) ===== --}}
    <style>
        /* Optional: highlight missing lot/expiry */
        select.is-invalid { border-color:#dc3545 !important; }
    </style>
    <script>
      (function () {
        'use strict';

        var form =
          document.getElementById('stock_transfer_form') ||
          document.querySelector('form[action*="stock-transfers"]') ||
          document.querySelector('form[action*="stock_transfer"]');

        if (!form) return;

        // Likely selector variants used by the Lot & Expiry dropdown in rows
        var LOT_SELECTORS =
          'select.lot_number, select.lot_no, select.lot_number_dropdown,' +
          'select[name*="[lot_no_line_id]"], select[name*="[lot_no]"], select[name*="[lot_numbers]"]';

        function getLotSelects() {
          return Array.prototype.slice.call(form.querySelectorAll(LOT_SELECTORS));
        }

        function markRequired() {
          getLotSelects().forEach(function (sel) {
            sel.setAttribute('required', 'required');
          });
        }

        function validateLots() {
          var ok = true, firstBad = null;

          getLotSelects().forEach(function (sel) {
            var val = (sel.value || '').trim();
            var label = (sel.options[sel.selectedIndex] && sel.options[sel.selectedIndex].text || '')
                          .trim().toLowerCase();

            // Treat blank / "-" / placeholder "Lot & Expiry" as invalid
            var missing = !val || val === '-' || label === 'lot & expiry';
            sel.classList.toggle('is-invalid', missing);

            if (missing) {
              ok = false;
              if (!firstBad) firstBad = sel;
            }
          });

          if (!ok) {
            if (window.toastr) {
              toastr.error('Please select a Lot & Expiry for every product row before saving.');
            } else {
              alert('Please select a Lot & Expiry for every product row before saving.');
            }
            if (firstBad) {
              firstBad.focus();
              try { firstBad.scrollIntoView({ behavior: 'smooth', block: 'center' }); } catch(e){}
            }
          }
          return ok;
        }

        // Enforce on submit
        form.addEventListener('submit', function (e) {
          markRequired();
          if (!validateLots()) {
            e.preventDefault();
            e.stopImmediatePropagation();
            return false;
          }
        }, true);

        // If rows are added/removed dynamically, keep the new selects required
        var observer = new MutationObserver(function () { markRequired(); });
        observer.observe(form, { childList: true, subtree: true });

        // Initial pass
        markRequired();
      })();
    </script>
@endsection



@cannot('view_purchase_price')
    <style>
        .show_price_with_permission {
            display: none !important;
        }
    </style>
@endcannot
